 /****** Object:  UserDefinedFunction [dbo].[F_ARREDONDAR_PRECO_VENDA_TABELA]    Script Date: 03/27/2013 17:13:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[F_ARREDONDAR_PRECO_VENDA_TABELA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[F_ARREDONDAR_PRECO_VENDA_TABELA]
GO
CREATE FUNCTION [dbo].[F_ARREDONDAR_PRECO_VENDA_TABELA] (@VLR_TABELA MONEY) 
	RETURNS MONEY AS 
BEGIN
DECLARE @FRACAO MONEY
DECLARE @VLRFINAL MONEY
DECLARE @VLR_TABELA_INTEIRO MONEY
DECLARE @FLAG_TIPO_ARREDONDAMENTO_PRECOS INT

--Tipo de arredondamento
--0 - Nao possui
--1 - Arred 6/0 e Arred 1/5
--2 - Por tabela 
SET @FLAG_TIPO_ARREDONDAMENTO_PRECOS=ISNULL((SELECT	
												VALOR
											FROM
												PRC_EMP_CONFIG
											WHERE
												CD_EMP=1
												AND CD_CHAVE='FLAG_TIPO_ARREDONDAMENTO_PRECOS'),0)



SET @VLR_TABELA_INTEIRO=FLOOR(@VLR_TABELA)
SET @FRACAO = @VLR_TABELA - @VLR_TABELA_INTEIRO;


--Nao possui
IF @FLAG_TIPO_ARREDONDAMENTO_PRECOS=0 
BEGIN
	SET @VLRFINAL = @VLR_TABELA 
END

--Por Arred 6/0 e Arred 1/5
IF @FLAG_TIPO_ARREDONDAMENTO_PRECOS=1 
BEGIN
	SET @VLR_TABELA=@VLR_TABELA*20

    If @FRACAO >= 0.5 
    BEGIN
	   SET @VLR_TABELA_INTEIRO = @VLR_TABELA_INTEIRO + 1
    END
	IF @Fracao <= -0.5 
       BEGIN
	    SET @VLR_TABELA_INTEIRO = @VLR_TABELA_INTEIRO - 1
		END
    
	SET @VLRFINAL = @VLR_TABELA_INTEIRO / 20
END

--Por tabela
IF @FLAG_TIPO_ARREDONDAMENTO_PRECOS = 2 
BEGIN
	
    SET @VLRFINAL = COALESCE((
		SELECT TOP 1
			CASE WHEN ACAO = 0 THEN
				(@VLR_TABELA_INTEIRO - VALOR_ACAO) + CASE WHEN VLR_TERMINACAO_DESEJADO >= 0.1 THEN VLR_TERMINACAO_DESEJADO ELSE ROUND(@FRACAO, 1, 1) + VLR_TERMINACAO_DESEJADO END 
			ELSE
				@VLR_TABELA_INTEIRO + VALOR_ACAO + CASE WHEN VLR_TERMINACAO_DESEJADO >= 0.1 THEN VLR_TERMINACAO_DESEJADO ELSE ROUND(@FRACAO, 1, 1) + VLR_TERMINACAO_DESEJADO END
			END
		FROM
			EST_PRECIFICACAO_PARAM_ARREDOND
		WHERE
			@VLR_TABELA BETWEEN VALOR_INICIAL AND VALOR_FINAL
			AND @FRACAO BETWEEN VLR_TERMINACAO_INICIAL AND VLR_TERMINACAO_FINAL) , @VLR_TABELA)
END

	RETURN @VLRFINAL END;
